/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.human.action;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;

import jp.mosp.common.action.MosPHumanAction;
import jp.mosp.common.common.MospConst;
import jp.mosp.human.dao.MKihonDao;
import jp.mosp.human.dto.MKihonDto;
import jp.mosp.payroll.base.Employee;
import jp.mosp.payroll.base.Payment;
import jp.mosp.payroll.base.PayrollAction;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.dao.CmBankDao;
import jp.mosp.payroll.dao.CmBranchDao;
import jp.mosp.payroll.dao.CmCoBankDao;
import jp.mosp.payroll.dao.CmCommutationDao;
import jp.mosp.payroll.dao.CmIncomeTaxDao;
import jp.mosp.payroll.dao.CmPaymentMeansDao;
import jp.mosp.payroll.dao.CmResidenceTaxDao;
import jp.mosp.payroll.dao.CmSocInsuranceDao;
import jp.mosp.payroll.dao.CmUnitAmountDao;
import jp.mosp.payroll.dao.PmDetailPaDao;
import jp.mosp.payroll.dao.PmDetailPbDao;
import jp.mosp.payroll.dao.PmDetailPdDao;
import jp.mosp.payroll.dao.PmDetailPsDao;
import jp.mosp.payroll.dao.PmDetailPtDao;
import jp.mosp.payroll.dto.CmBankDto;
import jp.mosp.payroll.dto.CmBranchDto;
import jp.mosp.payroll.dto.CmCoBankDto;
import jp.mosp.payroll.dto.CmCommutationDto;
import jp.mosp.payroll.dto.CmIncomeTaxDto;
import jp.mosp.payroll.dto.CmPaymentMeansDto;
import jp.mosp.payroll.dto.CmResidenceTaxDto;
import jp.mosp.payroll.dto.CmSocInsuranceDto;
import jp.mosp.payroll.dto.CmUnitAmountDto;
import jp.mosp.payroll.dto.PhPaymentDto;

public abstract class PayrollHumanAction extends MosPHumanAction {
	
	// tB[h
	protected String[][]                 aryUnitType       ;

	protected CmPaymentMeansDao          cmPaymentMeansDao ;
	protected List<CmPaymentMeansDto>    listPaymentMeans  ;
	protected CmPaymentMeansDto     	 cmPaymentMeansDto ;
	protected CmCommutationDao           cmCommutationDao  ;
	protected List<CmCommutationDto>     listCommutation   ;
	protected CmCommutationDto 	  	     cmCommutationDto  ;
	protected CmResidenceTaxDao          cmResidenceTaxDao ; 
	protected List<CmResidenceTaxDto>    listCmResidenceTax; 
	protected CmResidenceTaxDto          cmResidenceTaxDto ; 
	protected CmIncomeTaxDao             cmIncomeTaxDao    ;
	protected CmIncomeTaxDto             cmIncomeTaxDto    ;
	protected List<CmIncomeTaxDto>       listCmIncomeTax   ;
	protected CmUnitAmountDao            cmUnitAmountDao   ;
	protected List<CmUnitAmountDto>      listUnitAmount    ;
	protected CmUnitAmountDto     		 cmUnitAmountDto   ;
	protected CmSocInsuranceDao          cmSocInsuranceDao ;
	protected CmSocInsuranceDto          cmSocInsuranceDto ;

	protected List<CmSocInsuranceDto>    listCmSocInsurance;

	/**
	 * RXgN^
	 */
	protected PayrollHumanAction() {
		super();
		setCheckAuth(false);
	}

	/**
	 * l^擾
	 * @param kCode       ЈR[h
	 * @param isForUpdate Abvf[gptO
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 * @throws SQLException
	 */
	protected void findHumanCalcInfo(
			String kCode,
			boolean isForUpdate
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		// l^pDAO
		cmPaymentMeansDao = new CmPaymentMeansDao();
		cmPaymentMeansDao.initDao(cfg, cmd, aspUser, user, conn);
		cmCommutationDao = new CmCommutationDao();
		cmCommutationDao .initDao(cfg, cmd, aspUser, user, conn);
		cmResidenceTaxDao = new CmResidenceTaxDao();
		cmResidenceTaxDao.initDao(cfg, cmd, aspUser, user, conn);
		cmIncomeTaxDao    = new CmIncomeTaxDao   ();
		cmIncomeTaxDao   .initDao(cfg, cmd, aspUser, user, conn);
		cmUnitAmountDao   = new CmUnitAmountDao  ();
		cmUnitAmountDao  .initDao(cfg, cmd, aspUser, user, conn);
		cmSocInsuranceDao = new CmSocInsuranceDao();
		cmSocInsuranceDao.initDao(cfg, cmd, aspUser, user, conn);
		// ݂̏擾
		if (isForUpdate) {
			listPaymentMeans  = cmPaymentMeansDao.findForUpdate(kCode);
			listCommutation   = cmCommutationDao .findForUpdate(kCode);
			cmResidenceTaxDto = cmResidenceTaxDao.findForUpdate(kCode);
			cmIncomeTaxDto    = cmIncomeTaxDao   .findForUpdate(kCode);
			listUnitAmount    = cmUnitAmountDao  .findForUpdate(kCode);
			cmSocInsuranceDto = cmSocInsuranceDao.findForUpdate(kCode);
		} else {
			listPaymentMeans        = cmPaymentMeansDao.findForEmployee    (kCode);
			listCommutation         = cmCommutationDao .findForEmployee    (kCode);
			cmResidenceTaxDto       = cmResidenceTaxDao.findForEmployee    (kCode);
			listCmResidenceTax      = cmResidenceTaxDao.findForEmployeeList(kCode);
			cmIncomeTaxDto          = cmIncomeTaxDao   .findForEmployee    (kCode);
			listCmIncomeTax         = cmIncomeTaxDao   .findForEmployeeList(kCode);
			listUnitAmount          = cmUnitAmountDao  .findForEmployee    (kCode);
			cmSocInsuranceDto       = cmSocInsuranceDao.findForEmployee    (kCode);
			listCmSocInsurance      = cmSocInsuranceDao.findForEmployeeList(kCode);
		}
		// PڃXg擾
		aryUnitType = getPayment(kCode, null, PayrollConst.SLIP_ALL).getUnitItem();
	}
	
	/**
	 * VK^`[CX^X擾B<br>
	 * Ƃ{@link PayrollAction#getPayment}
	 * @param slipCode `[R[h
	 * @return VK^`[
	 * @throws NoSuchFieldException 
	 * @throws IllegalAccessException 
	 * @throws SQLException 
	 */
	private Payment getPayment(
			String kCode, Date calcMonth, String slipCode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		PhPaymentDto header = new PhPaymentDto();
		header.setKCode    (kCode    );
		header.setCalcMonth(calcMonth);
		header.setSlipCode (slipCode );
		return new Payment(
				header,
				new PmDetailPtDao(cfg, cmd, aspUser, user, conn).findForSlip(slipCode),
				new PmDetailPaDao(cfg, cmd, aspUser, user, conn).findForSlip(slipCode),
				new PmDetailPdDao(cfg, cmd, aspUser, user, conn).findForSlip(slipCode),
				new PmDetailPbDao(cfg, cmd, aspUser, user, conn).findForSlip(header.getSlipCode()),
				new PmDetailPsDao(cfg, cmd, aspUser, user, conn).findForSlip(slipCode)
		);
	}
	
	/**
	 * Ћs擾
	 * @param confId ݒ敪
	 * @return ݒ胊Xg
	 * @throws NoSuchFieldException 
	 * @throws IllegalAccessException 
	 * @throws SQLException 
	 */
	protected String[][] getCoBankArray()
		throws SQLException, IllegalAccessException, NoSuchFieldException {
		// DAO̐錾
		CmCoBankDao cmCoBankDao = new CmCoBankDao();
		cmCoBankDao.initDao(cfg, cmd, aspUser, user, conn);
		// f[^̎擾
		List<CmCoBankDto> list = cmCoBankDao.findAvailable();
		// f[^̐`
		String[][] array = new String[list.size()][2];
		for (int i = 0; i < list.size(); i++) {
			CmCoBankDto dto = list.get(i);
			array[i][0] = dto.getCoBankCode();
			array[i][1] = dto.getCoBankCode();
		}
		return array;
	}

	/**
	 * Nv_E擾
	 * @param year N
	 * @return Nv_Epz
	 */
	protected String[][] getYearArray(int year, int former, int further) {
		String[][] aryYear = new String[former + further + 1][2];
		int i = 0;
		int index = 0;
		for (i = year - former; i < year; i++) {
			aryYear[index][0] = String.valueOf(i);
			aryYear[index][1] = String.valueOf(i);
			index++;
		}
		aryYear[index][0] = String.valueOf(year);
		aryYear[index][1] = String.valueOf(year);
		index++;
		for (i = year + 1; i <= year + further; i ++) { 
			aryYear[index][0] = String.valueOf(i);
			aryYear[index][1] = String.valueOf(i);
			index++;
		}
		return aryYear;
	}

	/**
	 * sf[^JavaScriptt@CϊB<br>
	 * @param path o̓t@CpX
	 * @param name IuWFNg
	 * @throws Exception 
	 */
	public void convFinanceData(
			String path,
			boolean isCreate
	) throws Exception {
		// t@C擾
		File file = new File(path);
		// t@C݂Ȃꍇ܂isCreatetruȅꍇ
		if (!file.exists() | isCreate) {
			FileOutputStream fos = new FileOutputStream(path, false);
			OutputStreamWriter osw = new OutputStreamWriter(fos, "Windows-31J");
			StringBuffer sb = new StringBuffer();
			// s񖼐ݒ
			setJSArray(sb);
	        osw.write(sb.toString());
			osw.close();
			fos.close();
		}
	}

	/**
	 * sAxXzݒ
	 * @throws Exception 
	 */
	public void setJSArray(StringBuffer sb) throws Exception {
		// DAȌ
		CmBankDao dao = new CmBankDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ̎擾
		List<CmBankDto> listBank = dao.findAll();
		// s
		String[] aryJsBankCode = new String[listBank.size()];
		String[]aryJsBankName  = new String[listBank.size()];
		for (int i = 0; i < listBank.size(); i++) {
			CmBankDto cmBankDto = listBank.get(i);
			aryJsBankCode[i] = cmBankDto.getBankCode();
			aryJsBankName[i] = cmBankDto.getBankName();
		}
		// DAȌ
		CmBranchDao cmBranchDao = new CmBranchDao();
		cmBranchDao.initDao(cfg, cmd, aspUser, user, conn);
		// ̎擾
		List<CmBranchDto> listBranch = cmBranchDao.findAll();
		// z̍쐬
		// xX
		String[] aryJsBraBankCode = new String[listBranch.size()];
		String[] aryJsBranchCode  = new String[listBranch.size()];
		String[] aryJsBranchName  = new String[listBranch.size()];
		for (int i = 0; i < listBranch.size(); i++) {
			aryJsBraBankCode[i] = listBranch.get(i).getBankCode  ();
			aryJsBranchCode [i] = listBranch.get(i).getBranchCode();
			aryJsBranchName [i] = listBranch.get(i).getBranchName();
		}
		// sAxXzݒ
		setJSBankName(sb, aryJsBankCode, aryJsBankName, aryJsBraBankCode, aryJsBranchCode, aryJsBranchName);
	}

	/**
	 * JS֏nsݒ
	 * @param sb
	 */
	private void setJSBankName(StringBuffer sb, String[] aryJsBankCode, String[] aryJsBankName
			, String[] aryJsBraBankCode, String[] aryJsBranchCode, String[] aryJsBranchName
	) {
		// sR[h
		if (aryJsBankCode.length == 0) {
			sb.append("aryJsBankCode = new Array();");
			sb.append(MospConst.LINE_SEPARATOR);
		} else {
			sb.append("aryJsBankCode = new Array(");
			// ݒȂzJS
			for (int i = 0; i < aryJsBankCode.length; i++) {
				if (i == aryJsBankCode.length - 1) {
					sb.append("\"" + aryJsBankCode[i] + "\"" + ");");
				} else {
					sb.append("\"" + aryJsBankCode[i] + "\"" + ", ");
				}
			}
			sb.append(MospConst.LINE_SEPARATOR);
		}
		// s
		if (aryJsBankName.length == 0) {
			sb.append("aryJsBankName = new Array();");
			sb.append(MospConst.LINE_SEPARATOR);
		} else {
			sb.append("aryJsBankName = new Array(");
			// ݒȂzJS
			for (int i = 0; i < aryJsBankName.length; i++) {
				if (i == aryJsBankName.length - 1) {
					sb.append("\"" + aryJsBankName[i] + "\"" + ");");
				} else {
					sb.append("\"" + aryJsBankName[i] + "\"" + ", ");
				}
			}
			sb.append(MospConst.LINE_SEPARATOR);

		}
		
		// xXsR[h
		if (aryJsBraBankCode.length == 0) {
			sb.append("aryJsBraBankCode = new Array();");
			sb.append(MospConst.LINE_SEPARATOR);
		} else {
			sb.append("aryJsBraBankCode = new Array(");
			// ݒȂzJS
			for (int i = 0; i < aryJsBraBankCode.length; i++) {
				if (i == aryJsBraBankCode.length - 1) {
					sb.append("\"" + aryJsBraBankCode[i] + "\"" + ");");
				} else {
					sb.append("\"" + aryJsBraBankCode[i] + "\"" + ", ");
				}
			}
			sb.append(MospConst.LINE_SEPARATOR);
		}
		
		// xXR[h
		if (aryJsBranchCode.length == 0) {
			sb.append("aryJsBranchCode = new Array();");
			sb.append(MospConst.LINE_SEPARATOR);
		} else {
			sb.append("aryJsBranchCode = new Array(");
			// ݒȂzJS
			for (int i = 0; i < aryJsBranchCode.length; i++) {
				if (i == aryJsBranchCode.length - 1) {
					sb.append("\"" + aryJsBranchCode[i] + "\"" + ");");
				} else {
					sb.append("\"" + aryJsBranchCode[i] + "\"" + ", ");
				}
			}
			sb.append(MospConst.LINE_SEPARATOR);
		}
		
		// xX
		if (aryJsBranchName.length == 0) {
			sb.append("aryJsBranchName = new Array();");
			sb.append(MospConst.LINE_SEPARATOR);
		} else {
			sb.append("aryJsBranchName = new Array(");
			// ݒȂzJS
			for (int i = 0; i < aryJsBranchName.length; i++) {
				if (i == aryJsBranchName.length - 1) {
					sb.append("\"" + aryJsBranchName[i] + "\"" + ");");
				} else {
					sb.append("\"" + aryJsBranchName[i] + "\"" + ", ");
				}
			}
		}
		sb.append(MospConst.LINE_SEPARATOR);
	}

	/**
	 * v_EACe擾B<br>
	 * @return v_EACe
	 */
	protected String[][] getMonthArray() {
		String[][] aryMonth = new String[12][2];
		for (int i = 0; i < 12; i++) {
			aryMonth[i][0] = String.valueOf(i + 1);
			aryMonth[i][1] = String.valueOf(i + 1);
		}
		return aryMonth;
	}

	/**
	 * v_EACe擾B<br>
	 * @return v_EACe
	 */
	protected String[][] getDayArray() {
		String[][] aryDay = new String[31][2];
		for (int i = 0; i < 31; i++) {
			aryDay[i][0] = String.valueOf(i + 1);
			aryDay[i][1] = String.valueOf(i + 1);
		}
		return aryDay;
	}

}
